/****************************************************************************
 *   $Id:: pmutest.c 9376 2012-04-19 22:59:58Z nxp41306                     $
 *   Project: NXP LPC11xxLV PMU (Power Management Unit) example
 *
 *   Description:
 *     This file contains PMU slave test modules, main entry, to test PMU 
 *     slave APIs.
 *
****************************************************************************
* Software that is described herein is for illustrative purposes only
* which provides customers with programming information regarding the
* products. This software is supplied "AS IS" without any warranties.
* NXP Semiconductors assumes no responsibility or liability for the
* use of the software, conveys no license or title under any patent,
* copyright, or mask work right to the product. NXP Semiconductors
* reserves the right to make changes in the software without
* notification. NXP Semiconductors also make no representation or
* warranty that such application will be suitable for the specified
* use without further testing or modification.

* Permission to use, copy, modify, and distribute this software and its 
* documentation is hereby granted, under NXP Semiconductors' 
* relevant copyright in the software, without fee, provided that it 
* is used in conjunction with NXP Semiconductors microcontrollers.  This 
* copyright, permission, and disclaimer notice must appear in all copies of 
* this code.
****************************************************************************/
#include "LPC11xxLV.h"			/* LPC11xxLV Peripheral Registers */
#include "gpio.h"
#include "timer16.h"
#include "pmu.h"

extern volatile uint32_t timer16_0_counter;

void config_ios(void);

/*****************************************************************************
**   Main Function  main()
******************************************************************************/
int main (void)
{

SystemCoreClockUpdate();

LPC_SYSCON->PDRUNCFG |= (1<<3); //turn off BOD 
LPC_SYSCON->PDRUNCFG |= (1<<4); //turn off ADC
LPC_SYSCON->PDRUNCFG |= (1<<5); //turn off Sys Osc 
LPC_SYSCON->PDRUNCFG |= (1<<6);  //turn off WDT 
LPC_SYSCON->PDRUNCFG |= (1<<7); //turn off Sys PLL 
	
config_ios();

#if 1	
LPC_SYSCON->SYSAHBCLKCTRL = 0x1F;   
LPC_SYSCON->SSP0CLKDIV = 0x0;        
LPC_SYSCON->UARTCLKDIV = 0x0;     
LPC_SYSCON->WDTCLKDIV = 0x0; 
LPC_SYSCON->CLKOUTDIV = 0x0; 
#endif

	
LPC_SYSCON->SYSAHBCLKCTRL |= ((1<<6)|(1<<16));
	
LPC_IOCON->PIO1_8 &= ~(0x01F);
GPIOSetDir( 1, 8, 1 );
GPIOSetValue( 1, 8, 0 );

#if 0
/* enable CLK_OUT = main_clk*/
  LPC_SYSCON->CLKOUTUEN = 0;
  LPC_SYSCON->CLKOUTCLKSEL = 0;
  LPC_SYSCON->CLKOUTDIV = 1;
  LPC_SYSCON->CLKOUTUEN	= 1;

  //enable p0_1 as CLOCK_OUT
  LPC_IOCON->PIO0_1 &= ~0x07;
  LPC_IOCON->PIO0_1 |= 0x01;
#endif

//Initialize Wake-up pins
 PMU_Init(); 
 
 
 //SCB->SCR = 0x0;
// __WFI();
 
//Select one of the configurations when in deep sleep mode
//27 us wakeup time, 1.5 uA
PMU_Sleep( MCU_DEEP_SLEEP, 0x000018FF ); //all blocks powered down 

//5.7 us wakeup time, 8 uA
//PMU_Sleep( MCU_DEEP_SLEEP, 0x000018FD ); //keep only IRC powered in deep sleep mode but with no IRC output 

//3.9 us wakeup time, 950 uA
//PMU_Sleep( MCU_DEEP_SLEEP, 0x000018FC); //keep only IRC powered with IRC ouptut in deep sleep mode

while (1)
 {
   //tog pin for showing MCU is alive
   GPIOSetValue( 1, 8, ~GPIOGetValue(1, 8));
 }

}



void config_ios(void){

// Except RESET/PIO0_0, PIO0_1, SWDIO, SWDCLK, PIO0_2, and PIO1_8 pins, 
//configure rest of IOs as GPIO w/o pull-up & pull-down resistors, and drive as output low
	
	//Enable clock for GPIO
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<6);

	//Enable clock for IOCON
	LPC_SYSCON->SYSAHBCLKCTRL |= (1<<16);
	
/* Configure all IOs as GPIO w/o pull-up & pull-down resistors */
	LPC_IOCON->PIO2_0			= 0xC0;
	//LPC_IOCON->RESET_PIO0_0 	= 0xC1;
	//LPC_IOCON->PIO1_8			= 0xC0;
	//LPC_IOCON->PIO0_2			= 0xC0;      

	//LPC_IOCON->PIO2_1			= 0xC0;
	LPC_IOCON->PIO0_3			= 0xC0;     
	LPC_IOCON->PIO0_4			= 0xC0;      
	LPC_IOCON->PIO0_5			= 0xC0;      
	LPC_IOCON->PIO1_9			= 0xC0;      
	LPC_IOCON->PIO3_4			= 0xC0;

	LPC_IOCON->PIO3_5			= 0xC0;
	LPC_IOCON->PIO0_6			= 0xC0;     
	LPC_IOCON->PIO0_7			= 0xC0;

	LPC_IOCON->PIO0_8			= 0xC0;		
	LPC_IOCON->PIO0_9			= 0xC0;		
	//LPC_IOCON->SWCLK_PIO0_10	= 0xC1;	
	LPC_IOCON->PIO1_10			= 0xC0;		
	LPC_IOCON->R_PIO0_11	= 0xC1;		
	LPC_IOCON->R_PIO1_0  = 0xC1;	
	LPC_IOCON->R_PIO1_1  = 0xC1;	

	LPC_IOCON->R_PIO1_2 = 0xC1;	
	//LPC_IOCON->SWDIO_PIO1_3	= 0xC1;		
	LPC_IOCON->PIO1_4			= 0xC0;	
	LPC_IOCON->PIO1_11			= 0xC0;		

	LPC_IOCON->PIO1_5			= 0xC0;     
	LPC_IOCON->PIO1_6			= 0xC0;    
	LPC_IOCON->PIO1_7			= 0xC0;    


	/* GPIOs at outputs */
	LPC_GPIO0->DIR = 0xFFFFFFFF;
	LPC_GPIO1->DIR = 0xFFFFFFFF;
	LPC_GPIO2->DIR = 0xFFFFFFFF;
	LPC_GPIO3->DIR = 0xFFFFFFFF;

	/* GPIO outputs to LOW */
	LPC_GPIO0->DATA  = 0;
	LPC_GPIO1->DATA  = 0;
	LPC_GPIO2->DATA  = 0;
	LPC_GPIO3->DATA  = 0;

	return;
}
/*********************************************************************************
**                            End Of File
*********************************************************************************/
